header {* Transarithmetic: Axiomatic Classes *} 

theory TransNumberAxclass

imports Main Real

begin

subsection{*New constants: xor, infinity, sgn *} 

text{* Note: 
    This "list" xor is different from binary xor when there are three or more arguments. *} 

consts
   xor :: "bool list \<Rightarrow> bool" 
primrec 
  "xor [] = False"
  "xor (a # x) = ((xor x \<and> \<not> a) | (\<not> (list_ex id x) \<and> a))"; 

lemma xor_singleton: "xor [b] = b"; 
  by simp; 

lemma xor_pair: "xor [a,b] = (a \<noteq> b)"; 
  by auto; 

lemma xor_triple: 
  "xor [a,b,c] =  ((a \<and> \<not> b \<and> \<not>c) \<or> (\<not> a \<and> b \<and> \<not>c) \<or> (\<not> a \<and> \<not> b \<and> c))"; 
  by auto; 

axclass infinity < type

text{* Note: there is no separate constant minus-infinity *} 

consts 
   infinity :: "'a::infinity" ("\<infinity>" 100) 

axclass nullity < type
  consts
    nullity:: "'a ::nullity" ("\<Phi>")

axclass sgn < zero,one,minus, ord

consts
  sgn :: "'a :: sgn \<Rightarrow> 'a" 

axclass trans_sgn  < sgn,  nullity 
  trans_sgn: 
 "sgn a = (if 0 < a then 1 else 
                   if 0 = a then 0 else 
                   if a < 0 then - 1 else 
                   (* a = \<Phi> *)   \<Phi>)" 
 

subsection{* Axiomatic class trans\_add *} 

axclass 
  trans_add < zero, infinity, nullity, plus, minus 
  A1: "a + (b + c) = (a + b) + c"  (* add assoc *)
  A2: "a + b = b + a" (* add commute *) 
  A3: "0 + a = a"  (* add null *) 
  A4: "\<Phi> + a = \<Phi>"  (* add nullity *) 
  A5: "\<lbrakk> a \<noteq> -\<infinity>; a \<noteq> \<Phi> \<rbrakk> \<Longrightarrow> \<infinity> + a = \<infinity> "  (* add infinity *) 

  A6: "a - b = a + (-b)" (* subtraction *) 
  A7: "-(-a) = a"  (* uminus\_uminus *) 
  A8: "\<lbrakk> a \<noteq> \<infinity>; a \<noteq> -\<infinity>; a \<noteq> \<Phi> \<rbrakk> \<Longrightarrow> a - a = 0"  (* add inverse *) 
  A9: " -\<Phi> = \<Phi>"  (* uminus nullity *) 
  A10: "\<lbrakk> a \<noteq> \<infinity>; a \<noteq> \<Phi> \<rbrakk> \<Longrightarrow> a - \<infinity> = - \<infinity> "  (* real substract infinity, needed??? *) 
  A11: "\<infinity> - \<infinity> = \<Phi> "  (* infinity minus infinity *) 

instance trans_add \<subseteq> comm_monoid_add
  apply (intro_classes)
  apply (rule A1 [THEN sym]); 
  by ( rule A2, rule A3); 

subsection {* Axiomatic class trans\_mult (Axioms A12-A28) *} 

axclass 
  trans_mult <  trans_add, trans_sgn, one, times, inverse, ord 

  A12: "a * (b * c)= (a * b) * c "  (* mult assoc *) 
  A13: "a * b = b * a"  (* mult commute *) 
  A14: "1 * a = a"  (* one mult *) 


  A15: "\<Phi> * a = \<Phi>"  (* nullity mult *) 
  A16: "\<infinity> * 0 = \<Phi>"  (* infinity mult zero *) 
  A17: " a / b = a * inverse b" (* division defintion *) 
  A18: "\<lbrakk> a \<noteq> 0; a \<noteq> \<infinity>; a \<noteq> -\<infinity>; a \<noteq> \<Phi> \<rbrakk> \<Longrightarrow> a / a = 1"  (* mult inverse *) 
  A19: "a \<noteq> -\<infinity> \<Longrightarrow> inverse (inverse a) = a"  (* inverse of inverse *) 
  A20: "inverse 0 = \<infinity>" (* inverse of zero !!! *) 
  A21: "inverse (-\<infinity>) = 0" (* inverse of minus infinity *) 
  A22: "inverse \<Phi> = \<Phi>" (* inverse of nullity *) 

  A23: "(\<infinity> * a = \<infinity>) = (0 < a )"  (* positive *) 
  A24: "(\<infinity> * a = -\<infinity>) = (a < 0)"    (* negative *) 
  A25: "0 < \<infinity>" (* infinity is positive *) 

  A26: " (0 < a - b) = (b < a) " (* ordering positive *) 
  A27: "(a > b) =  (b < a)"       (* less than, trivial by translation rule for > *) 
  A28: "xor [a < 0, a = 0, 0 < a, a = \<Phi>]" (* quadrachotomy *) 

  A29: "\<not> ((a = \<infinity> \<or> a = - \<infinity>) \<and> sgn b \<noteq> sgn c \<and> (b + c \<notin> {0,\<Phi>})) 
         \<Longrightarrow> a * (b+c) = (a * b)+(a * c)"  (* distributivity *)

  A30: "a \<le> b = (a = b \<or> a < b)" (* definition of le *) 

instance trans_mult \<subseteq> comm_monoid_mult 
  by (intro_classes, rule A12 [THEN sym], rule A13, rule A14); 


subsection{* Axiomatic classes trans\_complete and  trans\_reals *} 

constdefs 
   lattice_complete :: "('a::ord) set \<Rightarrow> bool"
   "lattice_complete xs ==  
      \<forall> ys. ys \<subseteq> xs \<longrightarrow> (\<exists> u \<in> xs.  (\<forall> y \<in> ys. y \<le> u) 
                 \<and> (\<forall> v \<in> xs. (\<forall> y \<in> ys. y \<le> v) \<longrightarrow> u \<le> v))"

axclass  trans_complete < trans_add, one, times, inverse, ord 
   A31: "lattice_complete {x. x \<noteq> \<Phi>}"  

axclass trans_reals < trans_mult, trans_complete ; 

text{* TODO: validate definition by proving lattice-completeness of [0..1] *} 

end 




   


   





